 ; Ŀ
 ;   Detitle - make a detail title.                                        
 ;   Copyright 2000, 2001, 2006 by Rocket Software Ltd.                    
 ;   Cold blooded creatures secretly envy our women.                       
 ; 

 ; Ŀ
 ;   Twid - find the width of a hypothetical text string.                  
 ;   Takes one argument, the text entity data list, returns a length.      
 ; 
 (DEFUN TWID (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Twid end.                                                             
 ; 

 ; Ŀ
 ;   Detitle.                                                              
 ; 
 (DEFUN C:DETITLE (/ dwgscl pa detnam dwgnam title scal txwid1 txwid2 txwid
                                                                      pax pay)
  (setvar "cmdecho" 0)
  (setq dwgscl (getvar "dimscale"))
 ; Ŀ
 ;   Get an insertion point and strings.                                   
 ; 
  (setq pa (getpoint "\nInsertion: "))
  (setq detnam (getstring t "\nDetail Letter <A>: "))
  (if (= detnam "") (setq detnam "A"))
  (setq dwgnam (getstring t "\nDetail is on Drawing <~>: "))
  (if (= dwgnam "") (setq dwgnam "~"))
  (setq title (getstring t "\nTitle <XXX>: "))
  (if (= title "") (setq title "XXX"))
  (setq scal (getstring t "\nScale <NTS>: "))
  (if (= scal "") (setq scal "NTS"))
 ; Ŀ
 ;   Insert the block.                                                     
 ; 
  (command ".insert" "section" pa dwgscl "" "0" detnam dwgnam)
 ; Ŀ
 ;   Find the width of the detail title text string.                       
 ; 
  (setq txwid1 (twid (list (cons 1 title) (cons 40 (* dwgscl 3)))))
  (setq txwid2 (twid (list (cons 1 scal) (cons 40 (* dwgscl 2.5)))))
  (setq txwid (if (> txwid1 txwid2) txwid1 txwid2))
  (setq txwid (+ txwid dwgscl dwgscl))
  (if (< txwid (* dwgscl 36)) (setq txwid (* dwgscl 36)))
 ; Ŀ
 ;   Draw the line, make the text.                                         
 ; 
  (setq pax (polar pa 0 (* dwgscl 7)))
  (setq pay (polar pax 0 (+ txwid (* 2 dwgscl))))
  (command ".line" pax pay "")
  (setq pax (polar pax 0 (* 2 dwgscl)))
  (setq pa (polar pax 0 (/ txwid 2)))
  (setq pax (polar pa (/ pi 2) (* dwgscl 2)))
  (if c:malaya (malaya "text3"))
  (command ".text" "c" pax (* dwgscl 3) "0" title)
  (setq pay (polar pa (* pi 1.5) (* dwgscl 5)))
  (if c:malaya (malaya "text2"))
  (command ".text" "c" pay (* dwgscl 2.5) "0" scal)
 (princ))